/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.autoplot.APSplash;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUI;
import org.autoplot.datasource.TimeRangeEditor;
import org.autoplot.datasource.WindowManager;
import org.autoplot.dom.Application;
import org.autoplot.dom.ApplicationController;
import org.autoplot.dom.DataSourceController;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.TimeSeriesBrowseController;
import org.autoplot.help.AutoplotHelpSystem;
import org.das2.components.DatumRangeEditor;
import org.das2.components.GrannyTextEditor;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasPlot;
import org.das2.util.LoggerManager;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.layout.GroupLayout;

public class AxisPanel
extends JPanel {
    private final Application dom;
    private final ApplicationController applicationController;
    private DatumRangeEditor xredit;
    private DatumRangeEditor yredit;
    private DatumRangeEditor zredit;
    private Plot currentPlot;
    private BindingGroup plotBindingGroup;
    private boolean plotBindingGroupIsBound = false;
    private BindingGroup plotElementBindingGroup;
    private boolean plotElementBindingGroupIsBound = false;
    private String timeRangeBindingType = "none";
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.gui");
    private Runnable timeAxisChangeRunnable = new Runnable(){

        @Override
        public void run() {
            Plot p = AxisPanel.this.applicationController.getPlot();
            if (p != AxisPanel.this.currentPlot || AxisPanel.this.timeRangeBindingType.equals("xaxis") != UnitsUtil.isTimeLocation((Units)p.getXaxis().getRange().getUnits())) {
                AxisPanel.this.doCheckTimeRangeControllerEnable();
            }
        }
    };
    private PropertyChangeListener timeRangeAxisControllerEnabler = evt -> this.runOnEventThread(this.timeAxisChangeRunnable);
    private final PropertyChangeListener timeRangeContextControllerEnabler = evt -> this.runOnEventThread(() -> this.doCheckTimeRangeControllerEnable());
    PropertyChangeListener pcl1 = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DatumRange dr;
            if (AxisPanel.this.timeRangeBindingType.equals("xaxis")) {
                DatumRange dr2 = AxisPanel.this.currentPlot.getXaxis().getRange();
                if (dr2.getUnits().isConvertibleTo(AxisPanel.this.timeRangeEditor1.getRange().getUnits())) {
                    AxisPanel.this.timeRangeEditor1.setRange(dr2);
                }
            } else if (AxisPanel.this.timeRangeBindingType.startsWith("context") && (dr = AxisPanel.this.currentPlot.getContext()).getUnits().isConvertibleTo(AxisPanel.this.timeRangeEditor1.getRange().getUnits())) {
                AxisPanel.this.timeRangeEditor1.setRange(dr);
            }
        }
    };
    PropertyChangeListener timeRangeEditorListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DatumRange dr = AxisPanel.this.timeRangeEditor1.getRange();
            if (AxisPanel.this.timeRangeBindingType.equals("xaxis")) {
                if (dr.getUnits().isConvertibleTo(AxisPanel.this.currentPlot.getXaxis().getRange().getUnits())) {
                    AxisPanel.this.currentPlot.getXaxis().setRange(dr);
                }
            } else if (AxisPanel.this.timeRangeBindingType.startsWith("context") && dr.getUnits().isConvertibleTo(AxisPanel.this.currentPlot.getContext().getUnits())) {
                AxisPanel.this.currentPlot.setContext(dr);
            }
        }
    };
    private JCheckBox cbVisibleCB;
    private JButton colorbarGTEButton;
    private JCheckBox isotropicCheckBox;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JCheckBox legendEnableCheckbox;
    private JTextField legendTextField;
    private JCheckBox showXAxisLabelsCB;
    private TimeRangeEditor timeRangeEditor1;
    private JCheckBox titleCB;
    private JTextField titleTextField;
    private JPanel xAxisPanel;
    private JPanel xAxisRangePanel;
    private JCheckBox xLog;
    private JTextField xTitleTextField;
    private JButton xaxisGTEButton;
    private JPanel yAxisPanel;
    private JPanel yAxisRangePanel;
    private JCheckBox yLog;
    private JTextField yTitleTextField;
    private JButton yaxisGTEButton;
    private JPanel zAxisPanel;
    private JPanel zAxisRangePanel;
    private JCheckBox zLog;
    private JTextField zTitleTextField;
    private BindingGroup bindingGroup;

    public AxisPanel(ApplicationModel applicationModel) {
        APSplash.checkTime("in axispanel 10");
        this.dom = applicationModel.dom;
        this.applicationController = this.dom.getController();
        this.dom.addPropertyChangeListener("bindings", this.timeRangeContextControllerEnabler);
        this.applicationController.addPropertyChangeListener("plot", evt -> {
            Runnable run = () -> {
                Plot oldPlot = (Plot)evt.getOldValue();
                if (oldPlot != null) {
                    oldPlot.getXaxis().removePropertyChangeListener(this.timeRangeAxisControllerEnabler);
                }
                this.doPlotBindings();
            };
            SwingUtilities.invokeLater(run);
        });
        APSplash.checkTime("in axispanel 15");
        this.applicationController.addPropertyChangeListener("plotElement", evt -> {
            Runnable run = () -> this.doPlotElementBindings();
            SwingUtilities.invokeLater(run);
        });
        APSplash.checkTime("in axispanel 17");
        this.initComponents();
        APSplash.checkTime("in axispanel 20");
        DasPlot plot = this.applicationController.getPlot().getController().getDasPlot();
        DasColorBar colorbar = this.applicationController.getPlot().getController().getDasColorBar();
        this.xredit = new DatumRangeEditor();
        this.xredit.setValue((Object)plot.getXAxis().getDatumRange());
        this.xredit.addFocusListener(this.createDatumRangeEditorListener(this.xredit));
        this.xredit.setToolTipText("X axis range");
        this.xredit.setAllowZeroWidth(false);
        this.xAxisRangePanel.add((Component)this.xredit, "Center");
        this.yredit = new DatumRangeEditor();
        this.yredit.setValue((Object)plot.getYAxis().getDatumRange());
        this.yredit.addFocusListener(this.createDatumRangeEditorListener(this.yredit));
        this.yredit.setToolTipText("Y axis range");
        this.yredit.setAllowZeroWidth(false);
        this.yAxisRangePanel.add((Component)this.yredit, "Center");
        this.zredit = new DatumRangeEditor();
        this.zredit.setValue((Object)colorbar.getDatumRange());
        this.zredit.addFocusListener(this.createDatumRangeEditorListener(this.zredit));
        this.zredit.setToolTipText("Z axis range");
        this.zredit.setAllowZeroWidth(false);
        this.zAxisRangePanel.add((Component)this.zredit, "Center");
        APSplash.checkTime("in axispanel 30");
        this.xredit.addPropertyChangeListener(ev -> {
            DatumRange dr = (DatumRange)this.xredit.getValue();
            Runnable run = () -> {
                this.xLog.setEnabled(UnitsUtil.isRatioMeasurement((Units)dr.getUnits()));
                if (!this.xLog.isEnabled()) {
                    this.xLog.setSelected(false);
                }
            };
            SwingUtilities.invokeLater(run);
        });
        this.yredit.addPropertyChangeListener(ev -> {
            DatumRange dr = (DatumRange)this.yredit.getValue();
            Runnable run = () -> {
                this.yLog.setEnabled(UnitsUtil.isRatioMeasurement((Units)dr.getUnits()));
                if (!this.yLog.isEnabled()) {
                    this.yLog.setSelected(false);
                }
            };
            SwingUtilities.invokeLater(run);
        });
        this.zredit.addPropertyChangeListener(ev -> {
            DatumRange dr = (DatumRange)this.zredit.getValue();
            Runnable run = () -> {
                this.zLog.setEnabled(UnitsUtil.isRatioMeasurement((Units)dr.getUnits()));
                if (!this.zLog.isEnabled()) {
                    this.zLog.setSelected(false);
                }
            };
            SwingUtilities.invokeLater(run);
        });
        this.timeRangeEditor1.setNoOneListeningRange(Application.DEFAULT_TIME_RANGE);
        this.timeRangeEditor1.setRange(Application.DEFAULT_TIME_RANGE);
        this.doPlotBindings();
        this.doPlotElementBindings();
        this.timeRangeEditor1.addPropertyChangeListener("range", this.timeRangeEditorListener);
        APSplash.checkTime("in axispanel 40");
        AutoplotHelpSystem.getHelpSystem().registerHelpID((Component)this, "axesPanel");
        APSplash.checkTime("in axispanel 50");
    }

    private static void assertEventThread(String caller) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalArgumentException(caller + " must be called from the event thread.");
        }
    }

    @Override
    public void paint(Graphics g) {
        if (!this.plotBindingGroupIsBound) {
            this.plotBindingGroup.bind();
            this.plotBindingGroupIsBound = true;
        }
        if (!this.plotElementBindingGroupIsBound) {
            this.plotElementBindingGroup.bind();
            this.plotElementBindingGroupIsBound = true;
        }
        super.paint(g);
    }

    private FocusListener createDatumRangeEditorListener(final DatumRangeEditor edit) {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                edit.setValue(edit.getValue());
            }
        };
    }

    private void doPlotBindings() {
        AxisPanel.assertEventThread("doPlotBindings");
        BindingGroup bc = new BindingGroup();
        Plot p = this.applicationController.getPlot();
        if (this.plotBindingGroup != null) {
            this.plotBindingGroup.unbind();
        }
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"xaxis.label"), (Object)this.xTitleTextField, (Property)BeanProperty.create((String)"text_ON_ACTION_OR_FOCUS_LOST")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"xaxis.range"), (Object)this.xredit, (Property)BeanProperty.create((String)"value")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"xaxis.log"), (Object)this.xLog, (Property)BeanProperty.create((String)"selected")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"xaxis.drawTickLabels"), (Object)this.showXAxisLabelsCB, (Property)BeanProperty.create((String)"selected")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"yaxis.label"), (Object)this.yTitleTextField, (Property)BeanProperty.create((String)"text_ON_ACTION_OR_FOCUS_LOST")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"yaxis.range"), (Object)this.yredit, (Property)BeanProperty.create((String)"value")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"yaxis.log"), (Object)this.yLog, (Property)BeanProperty.create((String)"selected")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"zaxis.label"), (Object)this.zTitleTextField, (Property)BeanProperty.create((String)"text_ON_ACTION_OR_FOCUS_LOST")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"zaxis.range"), (Object)this.zredit, (Property)BeanProperty.create((String)"value")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"zaxis.log"), (Object)this.zLog, (Property)BeanProperty.create((String)"selected")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"zaxis.visible"), (Object)this.cbVisibleCB, (Property)BeanProperty.create((String)"selected")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"title"), (Object)this.titleTextField, (Property)BeanProperty.create((String)"text_ON_ACTION_OR_FOCUS_LOST")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"displayTitle"), (Object)this.titleCB, (Property)BeanProperty.create((String)"selected")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"isotropic"), (Object)this.isotropicCheckBox, (Property)BeanProperty.create((String)"selected")));
        this.plotBindingGroup = bc;
        this.plotBindingGroupIsBound = false;
        this.doCheckTimeRangeControllerEnable();
        p.getXaxis().addPropertyChangeListener("range", this.timeRangeAxisControllerEnabler);
        this.repaint();
    }

    private void runOnEventThread(Runnable run) {
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
    }

    private boolean isSomeoneListening(Plot p) {
        List<PlotElement> pes = this.dom.getController().getPlotElementsFor(p);
        for (PlotElement pe : pes) {
            DataSourceFilter dsf = pe.getController().getDataSourceFilter();
            DataSourceController dsfc = dsf.getController();
            if (dsfc == null) {
                return false;
            }
            TimeSeriesBrowseController tsbc = dsfc.getTimeSeriesBrowseController();
            if (tsbc == null || !p.getId().equals(tsbc.getPlotId())) continue;
            return true;
        }
        return false;
    }

    private void doCheckTimeRangeControllerEnable() {
        AxisPanel.assertEventThread("doCheckTimeRangeControllerEnable");
        Plot p = this.applicationController.getPlot();
        if (p == null) {
            return;
        }
        String type = UnitsUtil.isTimeLocation((Units)p.getXaxis().getRange().getUnits()) ? "xaxis" : (this.dom.getController().findBindings(p, "context").size() > 0 && this.dom.getController().isTimeSeriesBrowse(p) ? "context_" + p.getId() : (this.isSomeoneListening(p) ? "context_" + p.getId() : "none"));
        logger.log(Level.FINE, "timeRangeBindingType {0}", type);
        if (p != this.currentPlot && this.currentPlot != null) {
            this.currentPlot.removePropertyChangeListener(this.pcl1);
            this.currentPlot.getXaxis().removePropertyChangeListener(this.pcl1);
        }
        if (!type.equals(this.timeRangeBindingType) || p != this.currentPlot) {
            if (type.equals("xaxis")) {
                this.timeRangeEditor1.setEnabled(true);
                this.timeRangeEditor1.setToolTipText("controlling " + p.getId() + " xaxis");
                this.timeRangeBindingType = type;
                this.timeRangeEditor1.setRange(p.getXaxis().getRange());
            } else if (type.startsWith("context")) {
                this.timeRangeEditor1.setEnabled(true);
                this.timeRangeEditor1.setToolTipText("controlling " + p.getId() + ".context");
                this.timeRangeBindingType = type;
                this.timeRangeEditor1.setRange(p.getContext());
            } else {
                this.timeRangeEditor1.setEnabled(false);
                this.timeRangeEditor1.setToolTipText("plot context control has no effect.");
                this.timeRangeEditor1.setRange(this.timeRangeEditor1.getNoOneListeningRange());
                this.timeRangeBindingType = type;
            }
            this.currentPlot = p;
            this.currentPlot.addPropertyChangeListener(this.pcl1);
            this.currentPlot.getXaxis().addPropertyChangeListener(this.pcl1);
            this.timeRangeEditor1.setToolTipText(this.timeRangeBindingType);
        }
    }

    private void doPlotElementBindings() {
        AxisPanel.assertEventThread("doPlotElementBindings");
        BindingGroup bc = new BindingGroup();
        if (this.plotElementBindingGroup != null) {
            this.plotElementBindingGroup.unbind();
        }
        PlotElement p = this.applicationController.getPlotElement();
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"legendLabel"), (Object)this.legendTextField, (Property)BeanProperty.create((String)"text_ON_ACTION_OR_FOCUS_LOST")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)p, (Property)BeanProperty.create((String)"displayLegend"), (Object)this.legendEnableCheckbox, (Property)BeanProperty.create((String)"selected")));
        this.plotElementBindingGroup = bc;
        this.plotElementBindingGroupIsBound = false;
        this.repaint();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.xAxisPanel = new JPanel();
        this.xLog = new JCheckBox();
        this.xAxisRangePanel = new JPanel();
        this.xTitleTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.showXAxisLabelsCB = new JCheckBox();
        this.xaxisGTEButton = new JButton();
        this.zAxisPanel = new JPanel();
        this.zLog = new JCheckBox();
        this.zAxisRangePanel = new JPanel();
        this.zTitleTextField = new JTextField();
        this.cbVisibleCB = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.colorbarGTEButton = new JButton();
        this.yAxisPanel = new JPanel();
        this.yAxisRangePanel = new JPanel();
        this.yLog = new JCheckBox();
        this.isotropicCheckBox = new JCheckBox();
        this.yTitleTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.yaxisGTEButton = new JButton();
        this.jPanel1 = new JPanel();
        this.titleTextField = new JTextField();
        this.legendEnableCheckbox = new JCheckBox();
        this.legendTextField = new JTextField();
        this.titleCB = new JCheckBox();
        this.timeRangeEditor1 = new TimeRangeEditor();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.xAxisPanel.setBorder(BorderFactory.createTitledBorder("X Axis [?]"));
        this.xAxisPanel.setToolTipText("click title for help");
        this.xLog.setText("Log");
        this.xLog.setToolTipText("X axis logarithmic scale");
        this.xLog.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.xLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AxisPanel.this.xLogActionPerformed(evt);
            }
        });
        this.xAxisRangePanel.setLayout(new BorderLayout());
        this.xTitleTextField.setText("jTextField1");
        this.xTitleTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AxisPanel.this.axisMouseAction(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                AxisPanel.this.axisMouseAction(evt);
            }
        });
        this.jLabel1.setText("Label:");
        this.jLabel1.setToolTipText("X axis title");
        this.showXAxisLabelsCB.setText("Show Labels");
        this.showXAxisLabelsCB.setToolTipText("Hide the axis labels of the axis, to make a stack of plots more efficient.  Run Tools->\"Fix Layout\" to pack the plots.");
        this.showXAxisLabelsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AxisPanel.this.showXAxisLabelsCBActionPerformed(evt);
            }
        });
        this.xaxisGTEButton.setText("...");
        this.xaxisGTEButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AxisPanel.this.xaxisGTEButtonActionPerformed(evt);
            }
        });
        GroupLayout xAxisPanelLayout = new GroupLayout((Container)this.xAxisPanel);
        this.xAxisPanel.setLayout((LayoutManager)xAxisPanelLayout);
        xAxisPanelLayout.setHorizontalGroup((GroupLayout.Group)xAxisPanelLayout.createParallelGroup(1).add((GroupLayout.Group)xAxisPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)xAxisPanelLayout.createParallelGroup(1).add((Component)this.xAxisRangePanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)xAxisPanelLayout.createSequentialGroup().add((Component)this.xLog).add(18, 18, 18).add((Component)this.showXAxisLabelsCB).add(0, 9, Short.MAX_VALUE)).add((GroupLayout.Group)xAxisPanelLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.xTitleTextField).addPreferredGap(0).add((Component)this.xaxisGTEButton, -2, 17, -2))).addContainerGap()));
        xAxisPanelLayout.setVerticalGroup((GroupLayout.Group)xAxisPanelLayout.createParallelGroup(1).add((GroupLayout.Group)xAxisPanelLayout.createSequentialGroup().add((GroupLayout.Group)xAxisPanelLayout.createParallelGroup(3).add((Component)this.xTitleTextField, -2, -1, -2).add((Component)this.jLabel1).add((Component)this.xaxisGTEButton)).addPreferredGap(0).add((Component)this.xAxisRangePanel, -2, 27, -2).addPreferredGap(0).add((GroupLayout.Group)xAxisPanelLayout.createParallelGroup(3).add((Component)this.xLog).add((Component)this.showXAxisLabelsCB)).addContainerGap(12, Short.MAX_VALUE)));
        this.zAxisPanel.setBorder(BorderFactory.createTitledBorder("Colorbar [?]"));
        this.zAxisPanel.setToolTipText("click title for help");
        this.zLog.setText("Log");
        this.zLog.setToolTipText("colorbar logarithmic scale");
        this.zLog.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.zLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AxisPanel.this.zLogActionPerformed(evt);
            }
        });
        this.zAxisRangePanel.setLayout(new BorderLayout());
        this.zTitleTextField.setText("jTextField1");
        this.zTitleTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AxisPanel.this.axisMouseAction(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                AxisPanel.this.axisMouseAction(evt);
            }
        });
        this.cbVisibleCB.setText("Visible");
        this.cbVisibleCB.setToolTipText("hide/show colorbar");
        this.cbVisibleCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AxisPanel.this.cbVisibleCBActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Label:");
        this.jLabel3.setToolTipText("Colorbar title");
        this.colorbarGTEButton.setText("...");
        this.colorbarGTEButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AxisPanel.this.colorbarGTEButtonActionPerformed(evt);
            }
        });
        GroupLayout zAxisPanelLayout = new GroupLayout((Container)this.zAxisPanel);
        this.zAxisPanel.setLayout((LayoutManager)zAxisPanelLayout);
        zAxisPanelLayout.setHorizontalGroup((GroupLayout.Group)zAxisPanelLayout.createParallelGroup(1).add((GroupLayout.Group)zAxisPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)zAxisPanelLayout.createParallelGroup(1).add((Component)this.zAxisRangePanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)zAxisPanelLayout.createSequentialGroup().add((Component)this.zLog).add(18, 18, 18).add((Component)this.cbVisibleCB)).add((GroupLayout.Group)zAxisPanelLayout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.zTitleTextField).addPreferredGap(0).add((Component)this.colorbarGTEButton, -2, 17, -2))).addContainerGap()));
        zAxisPanelLayout.setVerticalGroup((GroupLayout.Group)zAxisPanelLayout.createParallelGroup(1).add((GroupLayout.Group)zAxisPanelLayout.createSequentialGroup().add((GroupLayout.Group)zAxisPanelLayout.createParallelGroup(3).add((Component)this.zTitleTextField, -2, -1, -2).add((Component)this.jLabel3).add((Component)this.colorbarGTEButton)).addPreferredGap(0).add((Component)this.zAxisRangePanel, -2, 27, -2).addPreferredGap(0).add((GroupLayout.Group)zAxisPanelLayout.createParallelGroup(3).add((Component)this.zLog).add((Component)this.cbVisibleCB)).addContainerGap(22, Short.MAX_VALUE)));
        this.yAxisPanel.setBorder(BorderFactory.createTitledBorder("Y Axis [?]"));
        this.yAxisPanel.setToolTipText("click title for help");
        this.yAxisRangePanel.setLayout(new BorderLayout());
        this.yLog.setText("Log");
        this.yLog.setToolTipText("Y axis logarithmic scale");
        this.yLog.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.yLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AxisPanel.this.yLogActionPerformed(evt);
            }
        });
        this.isotropicCheckBox.setText("Isotropic");
        this.isotropicCheckBox.setToolTipText("When Y axis units are convertable to X axis units, automatically set Y axis range to ensure pixel:data ratio is the same.");
        this.isotropicCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.isotropicCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AxisPanel.this.isotropicCheckBoxActionPerformed(evt);
            }
        });
        this.yTitleTextField.setText("jTextField1");
        this.yTitleTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AxisPanel.this.axisMouseAction(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                AxisPanel.this.axisMouseAction(evt);
            }
        });
        this.jLabel2.setText("Label:");
        this.jLabel2.setToolTipText("Y axis title");
        this.yaxisGTEButton.setText("...");
        this.yaxisGTEButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AxisPanel.this.yaxisGTEButtonActionPerformed(evt);
            }
        });
        GroupLayout yAxisPanelLayout = new GroupLayout((Container)this.yAxisPanel);
        this.yAxisPanel.setLayout((LayoutManager)yAxisPanelLayout);
        yAxisPanelLayout.setHorizontalGroup((GroupLayout.Group)yAxisPanelLayout.createParallelGroup(1).add((GroupLayout.Group)yAxisPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)yAxisPanelLayout.createParallelGroup(1).add((Component)this.yAxisRangePanel, -1, -1, Short.MAX_VALUE).add((Component)this.yLog).add((Component)this.isotropicCheckBox).add((GroupLayout.Group)yAxisPanelLayout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.yTitleTextField).addPreferredGap(0).add((Component)this.yaxisGTEButton, -2, 17, -2))).addContainerGap()));
        yAxisPanelLayout.setVerticalGroup((GroupLayout.Group)yAxisPanelLayout.createParallelGroup(1).add((GroupLayout.Group)yAxisPanelLayout.createSequentialGroup().add((GroupLayout.Group)yAxisPanelLayout.createParallelGroup(3).add((Component)this.yTitleTextField, -2, -1, -2).add((Component)this.jLabel2).add((Component)this.yaxisGTEButton)).addPreferredGap(0).add((Component)this.yAxisRangePanel, -2, 27, -2).addPreferredGap(0).add((Component)this.yLog).addPreferredGap(0).add((Component)this.isotropicCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Plot [?]"));
        this.jPanel1.setToolTipText("click title for help");
        this.titleTextField.setText("title will go here");
        this.titleTextField.setMaximumSize(new Dimension(700, Integer.MAX_VALUE));
        this.titleTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AxisPanel.this.titleMouseAction(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                AxisPanel.this.titleMouseAction(evt);
            }
        });
        this.legendEnableCheckbox.setText("Legend Label:");
        this.legendEnableCheckbox.setToolTipText("When selected, the label is added to the legend of the plot containing the focus plot element.\n\n");
        this.legendEnableCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AxisPanel.this.legendEnableCheckboxActionPerformed(evt);
            }
        });
        this.legendTextField.setText("label will go here");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.legendEnableCheckbox, (Property)ELProperty.create((String)"${selected}"), (Object)this.legendTextField, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.legendTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                AxisPanel.this.legendTextFieldMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                AxisPanel.this.legendTextFieldMouseReleased(evt);
            }
        });
        this.titleCB.setText("Title:");
        this.titleCB.setToolTipText("Title for the focus plot.  When deselected, the plot title is hidden.\n");
        this.titleCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AxisPanel.this.titleCBActionPerformed(evt);
            }
        });
        this.jButton1.setText("...");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AxisPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("...");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AxisPanel.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.timeRangeEditor1, -1, 395, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.titleCB).addPreferredGap(0).add((Component)this.titleTextField, -1, -1, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.legendEnableCheckbox).addPreferredGap(0).add((Component)this.legendTextField))).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((Component)this.jButton2, -2, 18, -2).add((Component)this.jButton1, -2, 1, Short.MAX_VALUE)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.titleTextField, -2, -1, -2).add((Component)this.titleCB).add((Component)this.jButton1)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.legendEnableCheckbox).add((Component)this.legendTextField, -2, -1, -2).add((Component)this.jButton2)).addPreferredGap(1).add((Component)this.timeRangeEditor1, -2, 25, -2).addContainerGap(20, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.xAxisPanel, -1, -1, Short.MAX_VALUE).add((Component)this.yAxisPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.zAxisPanel, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, 0, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.xAxisPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.yAxisPanel, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.zAxisPanel, -2, -1, -2)));
        this.bindingGroup.bind();
    }

    private void legendTextFieldMousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showLabelMenu(evt);
        }
    }

    private void legendTextFieldMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showLabelMenu(evt);
        }
    }

    private void axisMouseAction(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showAxisMenu(evt);
        }
    }

    private void titleMouseAction(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showTitleMenu(evt);
        }
    }

    private void xLogActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
    }

    private void showXAxisLabelsCBActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
    }

    private void yLogActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
    }

    private void isotropicCheckBoxActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
    }

    private void titleCBActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
    }

    private void legendEnableCheckboxActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
    }

    private void zLogActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
    }

    private void cbVisibleCBActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.addEditGrannyText(this.titleTextField);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.addEditGrannyText(this.legendTextField);
    }

    private void xaxisGTEButtonActionPerformed(ActionEvent evt) {
        this.addEditGrannyText(this.xTitleTextField);
    }

    private void yaxisGTEButtonActionPerformed(ActionEvent evt) {
        this.addEditGrannyText(this.yTitleTextField);
    }

    private void colorbarGTEButtonActionPerformed(ActionEvent evt) {
        this.addEditGrannyText(this.zTitleTextField);
    }

    private void addEditGrannyText(JTextField textField) {
        GrannyTextEditor gte = AutoplotUI.newGrannyTextEditorWithMacros();
        gte.setValue(textField.getText());
        if (0 == WindowManager.showConfirmDialog((Component)this, (Object)gte, (String)"Granny Text Editor", (int)2)) {
            textField.setText(gte.getValue());
            for (ActionListener al : textField.getActionListeners()) {
                try {
                    al.actionPerformed(null);
                }
                catch (NullPointerException ex) {
                    logger.info("getting NullPointerException where this once worked in AxisPanel");
                }
            }
        }
    }

    private JMenuItem createMenuItem(final JTextField componentTextField, final String insert, String doc) {
        JMenuItem result = new JMenuItem(new AbstractAction(insert){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                String v = componentTextField.getText();
                int i = componentTextField.getCaretPosition();
                componentTextField.setText(v.substring(0, i) + insert + v.substring(i));
            }
        });
        result.setToolTipText(doc);
        return result;
    }

    private JMenuItem createMenuItem(final JTextField componentTextField, final String insert, String label, String doc) {
        JMenuItem result = new JMenuItem(new AbstractAction(label){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                String v = componentTextField.getText();
                int i = componentTextField.getCaretPosition();
                componentTextField.setText(v.substring(0, i) + insert + v.substring(i));
            }
        });
        result.setToolTipText(doc);
        return result;
    }

    private JPopupMenu initLabelMenu(JTextField tf) {
        JPopupMenu processMenu = new JPopupMenu();
        processMenu.add(this.createMenuItem(tf, "%{COMPONENT}", "Component property from the plot element"));
        processMenu.add(this.createMenuItem(tf, "%{CONTEXT}", "Context from the dataset, such as slice location or component"));
        processMenu.add(this.createMenuItem(tf, "%{PLOT_CONTEXT}", "plot context control"));
        processMenu.add(this.createMenuItem(tf, "%{TIMERANGE}", "Special timerange property from the plot element controller"));
        processMenu.add(this.createMenuItem(tf, "%{PROPERTIES.CONTEXT_0}", "get a property from the plotted dataset"));
        processMenu.add(this.createMenuItem(tf, "%{USER_PROPERTIES.CUSTOMPROP}", "get a property from the USER_PROPERTIES of the plotted dataset"));
        processMenu.add(this.createMenuItem(tf, "!c", "Line Break", "Insert new line escape character"));
        return processMenu;
    }

    private void showLabelMenu(MouseEvent ev) {
        JPopupMenu processMenu = this.initLabelMenu((JTextField)ev.getSource());
        processMenu.show(ev.getComponent(), ev.getX(), ev.getY());
    }

    private JPopupMenu initTitleMenu(JTextField tf) {
        JPopupMenu processMenu = new JPopupMenu();
        processMenu.add(this.createMenuItem(tf, "%{CONTEXT}", "Context from the dataset, such as slice location or component"));
        processMenu.add(this.createMenuItem(tf, "%{TIMERANGE}", "Special timerange property from the plot element controller"));
        processMenu.add(this.createMenuItem(tf, "%{PLOT_CONTEXT}", "plot context control"));
        processMenu.add(this.createMenuItem(tf, "!c", "Line Break", "Insert new line escape character"));
        processMenu.add(this.createMenuItem(tf, "&epsilon;", "Insert named character reference for epsilon symbol"));
        processMenu.add(this.createMenuItem(tf, "&#0229;", "Insert unicode symbol"));
        return processMenu;
    }

    private void showTitleMenu(MouseEvent ev) {
        JPopupMenu processMenu = this.initTitleMenu((JTextField)ev.getSource());
        processMenu.show(ev.getComponent(), ev.getX(), ev.getY());
    }

    private JPopupMenu initAxisMenu(JTextField tf) {
        JPopupMenu processMenu = new JPopupMenu();
        processMenu.add(this.createMenuItem(tf, "%{UNITS}", "Units of the axis"));
        processMenu.add(this.createMenuItem(tf, "%{RANGE}", "Range of the axis"));
        processMenu.add(this.createMenuItem(tf, "%{SCAN_RANGE}", "Range of the axis scan buttons"));
        processMenu.add(this.createMenuItem(tf, "!c", "Line Break", "Insert new line escape character"));
        return processMenu;
    }

    private void showAxisMenu(MouseEvent ev) {
        JPopupMenu processMenu = this.initAxisMenu((JTextField)ev.getSource());
        processMenu.show(ev.getComponent(), ev.getX(), ev.getY());
    }
}

